<?php 
include_once("BDConexion.php");

function getPermisosLdap($grupos){
	/*EJEMPLO
		[count] => 12
		[0] => CN=ggd_apps_outlook,OU=WebApps,DC=lampa,DC=volcan,DC=win
		[1] => CN=ggd_apps_sso,OU=WebApps,DC=lampa,DC=volcan,DC=win
		[2] => CN=ggd_apps_sig,OU=WebApps,DC=lampa,DC=volcan,DC=win
		[3] => CN=ggd_apps_salesforce,OU=WebApps,DC=lampa,DC=volcan,DC=win
		[4] => CN=ggd_apps_aulavirtual,OU=WebApps,DC=lampa,DC=volcan,DC=win
		[5] => CN=ggd_apps_folios,OU=WebApps,DC=lampa,DC=volcan,DC=win
		[6] => CN=ggd_apps_beetrack,OU=WebApps,DC=lampa,DC=volcan,DC=win
		[7] => CN=ggd_apps_tiendavolcan,OU=WebApps,DC=lampa,DC=volcan,DC=win
		[8] => CN=ggd_apps_Issac,OU=WebApps,DC=lampa,DC=volcan,DC=win
		[9] => CN=VPN VIP,OU=Fortinet VPN,DC=lampa,DC=volcan,DC=win
		[10] => CN=WebAppsAdmin,OU=Servicios,DC=lampa,DC=volcan,DC=win
		[11] => CN=InternetUsers,DC=lampa,DC=volcan,DC=win
	*/
	$arrPermisos = array();
	if(count($grupos)>0){
		foreach($grupos as $permisos){
			if(strpos($permisos,"ggd_apps")>0){
				$row = explode(",",$permisos);
				$subrow = explode("=",$row[0]);
				$arrPermisos[] = $subrow[1];
			}
		}
	}
	return $arrPermisos;
}


function getApps(){
	$ObtieneAllDatos=new ControladorSp();
	$ObtieneAllDatos->ObtieneAllDatos();
	$arrData=array();
	$i=0;
	while ($ObtieneAllDatos->CargaDatosApp()) {
		$grupo = $ObtieneAllDatos->grupo_ldap;
		$arrData[$grupo]['nombre_app']=$ObtieneAllDatos->nomApp;
		$arrData[$grupo]['url_app']=$ObtieneAllDatos->url_app;
		//if(file_exists("img\\".$ObtieneAllDatos->grupo_ldap.".jpg")){
		if(file_exists('admin/img/'.$ObtieneAllDatos->grupo_ldap.".jpg")){
			$arrData[$grupo]['ruta']="admin/img/".$ObtieneAllDatos->grupo_ldap.".jpg";
		} else {
			$arrData[$grupo]['ruta']="admin/img/placeholder.jpg";
		}
		$arrData[$grupo]['codigo']=$ObtieneAllDatos->Codigo;
		$arrData[$grupo]['tipoApp']=$ObtieneAllDatos->tipo_app;
		$arrData[$grupo]['grupo_ldap']=$ObtieneAllDatos->grupo_ldap;
		$arrData[$grupo]['clase_app']=$ObtieneAllDatos->clase_app;
	$i++;   
	}
	return $arrData;
}

function getAppsAdmin(){
	$ObtieneAllDatos=new ControladorSp();
	$ObtieneAllDatos->ObtieneAllDatos();
	$arrData=array();
	$i=0;
	while ($ObtieneAllDatos->CargaDatosApp()) {
		$grupo = $ObtieneAllDatos->grupo_ldap;
		$arrData[$grupo]['nombre_app']=$ObtieneAllDatos->nomApp;
		$arrData[$grupo]['url_app']=$ObtieneAllDatos->url_app;
		//if(file_exists("img\\".$ObtieneAllDatos->grupo_ldap.".jpg")){
		if(file_exists('../admin/img/'.$ObtieneAllDatos->grupo_ldap.".jpg")){
			$arrData[$grupo]['ruta']="img/".$ObtieneAllDatos->grupo_ldap.".jpg";
		} else {
			$arrData[$grupo]['ruta']="img/placeholder.jpg";
		}
		$arrData[$grupo]['codigo']=$ObtieneAllDatos->Codigo;
		$arrData[$grupo]['tipoApp']=$ObtieneAllDatos->tipo_app;
		$arrData[$grupo]['grupo_ldap']=$ObtieneAllDatos->grupo_ldap;
		$arrData[$grupo]['clase_app']=$ObtieneAllDatos->clase_app;
	$i++;   
	}
	return $arrData;
}

function getAppsClases(){
	$ObtieneAllDatos=new ControladorSp();
	$ObtieneAllDatos->ObtieneAllDatos();
	$arrData=array();
	while ($ObtieneAllDatos->CargaDatosApp()) {
		$claseApp = $ObtieneAllDatos->clase_app;
		if(!in_array($claseApp,$arrData)){
			$arrData[] = $claseApp;
		}
	}
	asort($claseApp);
	return $arrData;
}

function getClases(){
	$ObtieneClases=new ControladorSp();
	$ObtieneClases->ObtieneClases();
	$arrData=array();
	while ($ObtieneClases->CargaDatosClases()) {
		$row=array();
		$row["idclases"] = $ObtieneClases->idclases;
		$row["nombre"] = $ObtieneClases->nombre;
		$row["orden"] = $ObtieneClases->orden;
		$row["estado"] = $ObtieneClases->estado;
		$arrData[] = $row;
	}
	return $arrData;
}


function getClasesActivas(){
	$ObtieneClases=new ControladorSp();
	$ObtieneClases->ObtieneClases();
	$arrData=array();
	while ($ObtieneClases->CargaDatosClases()) {
		if($ObtieneClases->estado==1){
			$row=array();
			$row["idclases"] = $ObtieneClases->idclases;
			$row["nombre"] = $ObtieneClases->nombre;
			$row["orden"] = $ObtieneClases->orden;
			$row["estado"] = $ObtieneClases->estado;
			$arrData[] = $row;
		}
	}
	return $arrData;
}

function getClasesById($id){
	$ObtieneClases=new ControladorSp();
	$ObtieneClases->ObtieneClases();
	$arrData=array();
	while ($ObtieneClases->CargaDatosClases()) {
		if($ObtieneClases->idclases==$id){
			$row=array();
			$row["idclases"] = $ObtieneClases->idclases;
			$row["nombre"] = $ObtieneClases->nombre;
			$row["orden"] = $ObtieneClases->orden;
			$row["estado"] = $ObtieneClases->estado;
			$arrData = $row;
		}
	}
	return $arrData;
}

?>