<?php
//error_reporting(0);
include("../inc/ControlerLdap.php");
if(basename($_SERVER['SCRIPT_FILENAME'])==basename(__FILE__))
	exit;

/**
 * Acceso a los métodos del sistema
 * 
 * @service WSWEBAPPS
 */
class WSWEBAPPS{
	/**
	 * WAPPLOGIN
	 * 
	 * @param string $User Nombre de usuario de LDAP
	 * @param string $Pass Numero de Transporte asociado para recuperación de datos
	 * @return WAPPLOGIN Resultado del logueo al sistema
	 */
	public function WAPPLOGIN($User,$Pass){
		$WS_APK_MSG = new stdClass(); //Objeto que contendrá los mensajes de respuestas 
		$WS_APK_MSGS = ''; //Variable de publicación de los mensajes
		$WS_APK_DATA = new ArrayObject(); //Detalles de los datos de respuesta
		$WS_APK_ROWS = new ArrayObject(); //Filas de datos
		$WS_APK_RETURN = new stdClass(); //Variable de Retorno de los datos para WS
		$VALIDO = false;
		if(strlen($User)==0||strlen($Pass)==0){
			$WS_APK_MSG->ESTADO = 'ERROR';
			$WS_APK_MSG->MENSAJE = 'Debe ingresar usuario y clave válidos.';
		} else {
			$LoginAPPs=new ControlerLdap();
			$LoginAPPs->Login($User,$Pass);
			if ($LoginAPPs->valido==true) {
				$VALIDO = true;       
			}  
			if($VALIDO){
				$WS_APK_MSG->ESTADO = 'OK';
				$WS_APK_MSG->MENSAJE = 'User y Pass correctos ';
				$WS_APK_ROW_COUNTER = 0;
				$WS_APK_DATA[$WS_APK_ROW_COUNTER]->USUARIO = $User;
				$WS_APK_DATA[$WS_APK_ROW_COUNTER]->PASS = $Pass;
				$WS_APK_DATA[$WS_APK_ROW_COUNTER]->VALIDO = 'OK';
				$WS_APK_ROWS[] = new SoapVar($WS_APK_DATA[$WS_APK_ROW_COUNTER], SOAP_ENC_OBJECT, 'RespuestaAcceso', null, 'ValidaAcceso');
			} else {
				$WS_APK_MSG->ESTADO = 'OK';
				$WS_APK_MSG->MENSAJE = 'No se encontró el usuario ' . $User;
			}
		}
		$WS_APK_MSGS = new SoapVar($WS_APK_MSG, SOAP_ENC_OBJECT, 'MsgWAPPLOGIN');
		$WS_APK_RETURN->RESPUESTA = $WS_APK_MSGS;
		$WS_APK_RETURN->DATOS = $WS_APK_ROWS;
		$outputData = serialize($WS_APK_RETURN);
		return $WS_APK_RETURN;
	}
	/**
	 * WAPPSYNCAPPS
	 * 
	 * @param string $User Usuario de LDAP
	 * @return APKSYNCAPPS Resultado de guias a sincronizar
	 */
	public function WAPPSYNCAPPS($User){
		$WS_APK_MSG = new stdClass(); //Objeto que contendrá los mensajes de respuestas 
		$WS_APK_MSGS = ''; //Variable de publicación de los mensajes
		$WS_APK_DATA = new ArrayObject(); //Detalles de los datos de respuesta
		$WS_APK_ROWS = new ArrayObject(); //Filas de datos
		$WS_APK_RETURN = new stdClass(); //Variable de Retorno de los datos para WS
		$VALIDO = false;
		if(strlen($User)==0){
			$WS_APK_MSG->ESTADO = 'ERROR';
			$WS_APK_MSG->MENSAJE = 'Nombre de usuario inválido';
		} else {
			$WS_APK_MSG->ESTADO = 'OK';
			$WS_APK_MSG->MENSAJE = 'User valido ' . $User;
			$WS_APK_ROW_COUNTER = 0;
			session_start();
			include_once("../inc/controladorSp.php");
			$ObtenerDatosAplicacion=new controladorSp();
			$ObtenerDatosAplicacion->ObtenerIDPermisos($User);
			//var_dump($ObtenerDatosAplicacion->ObtenerIDPermisos($User));exit;
			//$ObtenerNulos=new ControladorSp();
			//$ObtenerNulos->spObtenerNulos($User);
			//var_dump($ObtenerDatosAplicacion->CargaDatosApp());exit;
			while ($ObtenerDatosAplicacion->CargaDatosApp()) {
				echo  $ObtenerDatosAplicacion->codigoApp;
				$WS_APK_DATA[$WS_APK_ROW_COUNTER]->NOMBREAPP = $ObtenerDatosAplicacion->nomApp;				
				$WS_APK_DATA[$WS_APK_ROW_COUNTER]->CODIGO = $ObtenerDatosAplicacion->Codigo;
				$WS_APK_DATA[$WS_APK_ROW_COUNTER]->TIPOAPP = $ObtenerDatosAplicacion->tipo_app;
				$WS_APK_DATA[$WS_APK_ROW_COUNTER]->URL = $ObtenerDatosAplicacion->url_app;
				switch($ObtenerDatosAplicacion->tipo_app){
					case "LOGIN":
						$appData=new ControladorSp();
						$appData->ObtenerPermisos($ObtenerDatosAplicacion->Codigo,$User);
						while ($appData->CargaDatosPermisos()) {
							$WS_APK_DATA[$WS_APK_ROW_COUNTER]->USERLOGIN = $appData->userLogin;
							$WS_APK_DATA[$WS_APK_ROW_COUNTER]->PASSLOGIN = $appData->passLogin;
						}
					break;
				}
				$WS_APK_ROWS[] = new SoapVar($WS_APK_DATA[$WS_APK_ROW_COUNTER], SOAP_ENC_OBJECT, 'RespuestaApps', null, 'ValidaApps');
				$WS_APK_ROW_COUNTER++;
			}
		}
		$WS_APK_MSGS = new SoapVar($WS_APK_MSG, SOAP_ENC_OBJECT, 'MensajeWSSYNCAPPS');
		$WS_APK_RETURN->RESPUESTA = $WS_APK_MSGS;
		$WS_APK_RETURN->APPS = $WS_APK_ROWS;
		$outputData = serialize($WS_APK_RETURN);
		return $WS_APK_RETURN;
	}
	/**
	 * WAPPSAVECRD
	 * 
	 * @param string $User Usuario de LDAP
	 * @param string $CodeApp Código de la aplicación
	 * @param string $AppUser Usuario de la aplicación
	 * @param string $AppPass Password de la aplicación
	 * @return RESPSAVECRD Resultado de la inserción de credenciales
	 */
	public function WAPPSAVECRD($User,$CodeApp,$AppUser,$AppPass){
		$WS_APK_MSG = new stdClass(); //Objeto que contendrá los mensajes de respuestas 
		$WS_APK_MSGS = ''; //Variable de publicación de los mensajes
		$WS_APK_DATA = new ArrayObject(); //Detalles de los datos de respuesta
		$WS_APK_ROWS = new ArrayObject(); //Filas de datos
		$WS_APK_RETURN = new stdClass(); //Variable de Retorno de los datos para WS
		$VALIDO = false;
		if(strlen($AppUser)==0||strlen($AppPass)==0){
			$WS_APK_MSG->ESTADO = 'ERROR';
			$WS_APK_MSG->MENSAJE = 'Debe indicar user y password válidos para la aplicación';
		} else {
			$WS_APK_MSG->ESTADO = 'OK';
			$WS_APK_MSG->MENSAJE = 'User y password válidos para la aplicación ';
			$WS_APK_ROW_COUNTER = 0;
			session_start();
			include_once("../inc/controladorSp.php");
			$insertCredentials=new controladorSp();
			$insertCredentials->InsertExtLogin($User,$CodeApp,$AppUser,$AppPass);
			//print_r($insertCredentials->InsertExtLogin($User,$CodeApp,$AppUser,$AppPass));
			$WS_APK_DATA[$WS_APK_ROW_COUNTER]->USERLOGIN = $AppUser;
			$WS_APK_DATA[$WS_APK_ROW_COUNTER]->PASSLOGIN = $AppPass;
			$WS_APK_DATA[$WS_APK_ROW_COUNTER]->NOMBREAPP = $CodeApp;
			$WS_APK_ROWS[] = new SoapVar($WS_APK_DATA[$WS_APK_ROW_COUNTER], SOAP_ENC_OBJECT, 'RespuestaCrd', null, 'SaveCrd');
		}
		$WS_APK_MSGS = new SoapVar($WS_APK_MSG, SOAP_ENC_OBJECT, 'MsjWAPPSAVECRD');
		$WS_APK_RETURN->RESPUESTA = $WS_APK_MSGS;
		$WS_APK_RETURN->RESPSAVECRD = $WS_APK_ROWS;
		$outputData = serialize($WS_APK_RETURN);
		return $WS_APK_RETURN;
	}
}
